using System;
using System.Windows.Forms;

using gov.va.med.vbecs.DAL.VistALink.Client;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.DAL.VAL;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Layering component providing late binding for VistALink and UI components. 
	/// Created to decouple VistALink data access classes from UI implementation.
	/// </summary>
	public class VbecsVistALinkUIBinder : VistALinkUIBinder
	{
		private VbecsUser _vbecsUser;

		/// <summary>
		/// Constructs binder object.
		/// </summary>
		/// <param name="vbecsUser">Currently logged on user.</param>
		/// <param name="parentWindow">Reference to parent window for modal dialogs invoked by VistALink.</param>
		public VbecsVistALinkUIBinder( VbecsUser vbecsUser, Form parentWindow )
			: base( parentWindow )
		{
			if( vbecsUser == null )
				throw( new ArgumentNullException( "vbecsUser" ) );

			_vbecsUser = vbecsUser;
		}
		
		/// <summary>
		/// Crossmatches VistA and VBECS division objects (they both represent the same entity) by
		/// searching supplied list of VistA divisions for division code corresponding to the division user
		/// logged-on in VBECS. Throws an exception if division code from VBECS does not match any division 
		/// in a given list of VistA divisions.
		/// </summary>
		/// <param name="serverInfo">Remote server info provided by the <see cref="VistALink"/> internals.</param>
		/// <param name="serverConnectionInfo">Remote server connection info provided by the <see cref="VistALink"/> internals.</param>
		/// <param name="divisionList">List of VistA divisions available for logged on user.</param>
		/// <param name="userSelectedDivision">VistA division corresponding to user-selected VBECS division.</param>
		/// <returns>
		///		Returns false if VBECS division is not present among VistA divisions available for user (thereby cancelling the logon process). 
		///		Normally will return true.
		///	</returns>
		public override bool GetVistADivisionSelection( RemoteServerSetupAndIntroInfo serverInfo, ServerConnectionInfo serverConnectionInfo, DivisionInfoCollection divisionList, out DivisionInfo userSelectedDivision )
		{
			int nCount = 0;
			if( serverInfo == null )
				throw( new ArgumentNullException( "serverInfo" ) );

			if( serverConnectionInfo == null )
				throw( new ArgumentNullException( "serverConnectionInfo" ) );

			userSelectedDivision = null;

			string _userDivisionCode = LogonUser.LogonUserDivisionCode.Trim();
			nCount = divisionList.Count;
			for( int _divIndex = 0; _divIndex < nCount; _divIndex++ )
			{
				if( divisionList[ _divIndex ].Number.Trim() == _userDivisionCode )
				{
					userSelectedDivision = divisionList[ _divIndex ];
					return true;
				}
			}
			
			NotifyAboutProblem( StrRes.SysErrMsg.UC018.VbecsUserDivisionNotFoundAmongVistADivisions( _userDivisionCode ).ResString );

			return false;
		}
	}
}
